s           V                                         gmsspx      GM SSP X  Power Source (VISA)                   ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViString     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]  W    This instrument module provides programming support for the GM SSP X Power Sources. The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Function Examples: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Data Functions: (Class)
This class of functions transfers data to or from the instrument.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
    8    This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

Functions/SubClasses:

(1) Application Example:
This function sets the voltage/current setponts and limits and sets the output state to On.
        This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

(1) Voltage Configuration: (Class)
This class configures voltage settings

(2) Current Configuration: (Class)
This class configures current settings

(3) Output Configuration: (Class)
This class configures output settings

(4) Sequence Configuration: (Class)
This class configures sequence settings

(5) Analog Interface Configuration: (Class)
This class configures analog interface settings

(6) MinMax Configuration: (Class)
This class configures minmax settings

(7) Set Power-On Mode:
This function defines the status of the device setting after power on.

(8) Get Power-On Mode:
This function queries the status of the device setting after power on.
        This class configures voltage settings.

Functions/Classes:

(1) Set Voltage Setting:
This function sets the setpoint value of the output voltage.

(2) Get Voltage Setting:
This function queries the setpoint value of the output voltage.

(3) Set Voltage Limit:
This function defines the upper soft limit for the current setpoint.

(4) Get Voltage Limit:
This function queries the upper soft limit for the voltage setpoint.

(5) Set OVP Level:
This function defines Over Voltage Protection level.

(6) Get OVP Level:
This function queries Over Voltage Protection level.

(7) Get Max Voltage:
This function returns the upper voltage limit of the instrument.
        This class configures current settings.

Functions/Classes:

(1) Set Current Setting:
This function sets the setpoint value of the output current.

(2) Get Current Setting:
This function queries the setpoint value of the output current.

(3) Set Current Limit:
This function defines the upper soft limit for the current setpoint.

(4) Get Current Limit:
This function queries the upper soft limit for the current setpoint.

(5) Set OCP Delay:
This function defines the OCP delay.

(6) Get OCP Delay:
This function queries the OCP delay.

(7) Set OCP State:
This function selects OCP ON/OFF.

(8) Get OCP State:
This function queries OCP state.

(9) Get Max Current:
This function returns the upper current limit of the instrument.
        This class configures output settings.

Functions/Classes:

(1) Set Output State:
This function selects power output ON/OFF.

(2) Get Output State:
This function queries power output state.

(3) Get Output Mode:
This function queries the actual operating mode of the output.
    @    This class configures sequence settings.

Functions/Classes:

(1) Sequence Setting:
This function sets the Sequence.

(2) Set Sequence State:
This function sets the Sequence State.

(3) Get Sequence State:
This function queries Sequence State.

(4) Set Sequence Repetition:
This function defines Sequence Repetition.

(5) Get Sequence Repetition:
This function queries Sequence Repetition.

(6) Set Sequence Start Stop Address:
This function defines Sequence Range.

(7) Get Sequence Start Stop Address:
This function queries Sequence Range.

(8) Set Sequence Default Time:
This function defines Default Sequence Time.

(9) Get Sequence Default Time:
This function queries Default Sequence Time.

(10) Set Sequence Step Time:
This function defines Sequence Time.

(11) Get Sequence Step Time:
This function queries Sequence Time.
    K    This class configures analog interface settings.

Functions/Classes:

(1) Set Sig1_Sig2:
This function defines specific function for Signal1 and Signal2 outputs on Analog Interface. 

(2) Get Sig1_Sig2:
This function queries specific function for Signal1 and Signal2 outputs on Analog Interface.

(3) Set Trigger Mode:
This function defines Trigger Mode.

(4) Get Trigger Mode:
This function returns Trigger Mode.

(5) Set Sset:
This function sets Signal Set (SSet) functionallity in the instrument.

(6) Get Sset:
This function gets Signal Set (SSet) functionallity in the instrument.         This class configures minmax settings.

Functions/Classes:

(1) Set MinMax State:
This function selects MINMAX mode.

(2) Get MinMax State:
This function queries MINMAX mode.
    <    This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions/SubClasses:

(1) Send Sequence Trigger:
This function sends Sequence trigger.

(2) Reset MinMax:
This function resets values in MinMax memory.
         This class of functions transfers data to or from the instrument.

Functions/SubClasses:

(1) Measurement Functions: (Class)
This class measure output values.

(2) Register Functions: (Class)
This class manages register operations.
    9    This class measure output values.

Functions/Classes:

(1) Fetch Min Max Measurement:
This function returns the limit values of the output current and voltage measured and saved in MINMAX memory during MINMAX ON.

(2) Meas Output Voltage:
This function queries the actual measured value of the output voltage.

(3) Meas Output Current:
This function queries the actual measured value of the output current.

(4) Meas Output Power:
This function queries the actually measured power on the output.
The time required to acquire and process the reading is approx. 90 ms.
        This class manages register operations.

Functions/Classes:

(1) Recall Register:
This function recalls the specified register from the instrument's memory.

(2) Save Register:
This function stores settings to the register in instrument's memory.

(3) Store Register Data:
This function stores parameters to register.

(4) Store Register Data Array:
This function stores parameters to more registers.

        This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:
(1) Set System Register:
This function sets specified value to register.

(2) Set Register:
This function gets specified value from register.

(3) Check State:
This function switches ON/OFF state checking of the instrument (reading of the Standard Event Register and checking it for error).

(4) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(5) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(6) Reset:
This function resets the instrument to its default state.

(7) Self-Test:
This function runs the instrument self test and returns the test code.

(8) Diagnostics:
This function runs a set of the instrument's internal diagnostic routines and returns the results. 

(9) Error-Query:
This function reads an error code from the instrument error queue.

(10) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(11) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.

(12) Set Display State:
This function selects display mode. This function enables the digital display to be signalled OFF if remote control is active.

(13) Get Display State:
This function queries display mode.

(14) Get Instrument Model:
This function returns the instrument model as a string and a number.

(15) Set I/O Delay Time:
This function defines the delay between I/O operations.

(16) Get I/O Delay Time:
This function returns the instrument model as a string and a number.

(17) Address:
This function address the appropriate instrument when several instruments are chained via serial cable.

(18) Lock Instrument:
This function locks/unlocks the instrument.    2    This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state.

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "GPIB::13"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
Serial      ASRL<port>::INSTR
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]

The ASRL keyword is used with Serial instruments.
The GPIB keyword is used with GPIB instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
secondary address           none - 31
    #    This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_FALSE (0) - Skip Query
VI_TRUE  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.
    H    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_FALSE (0) - Don't Reset
VI_TRUE  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.
    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0011  Instrument returned invalid response to ID Query
BFFC09F1  Unknown instrument model          

This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
    (	 =         Resource Name                     + :        ID Query                          - =        Reset Device                      /B     }    Instrument Handle                 0      Status                             "GPIB::13"  % Do Query VI_TRUE Skip Query VI_FALSE  * Reset Device VI_TRUE Don't Reset VI_FALSE    	           	           _    This function sets the voltage/current setpoints and limits and sets the output state to On.
    g    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage Limit) out of range.
BFFC0003  Parameter 3 (Current Limit) out of range.
BFFC0004  Parameter 4 (Voltage Setting) out of range.
BFFC0005  Parameter 5 (Current Setting) out of range.
BFFC0006  Parameter 6 (Output Voltage) Null pointer.
BFFC0007  Parameter 7 (Output Current) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    &    This control sets the setpoint value of the output current.

Default Value: 1.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (A)   |   Resolution (mA)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...10 A      |        2.5 mA       |
32 N 40 RU  6 P |       0....6 A      |          2 mA       |
32 N 80 RU  3 P |       0....3 A      |          1 mA       |
32 N 20 RU 20 P |       0...20 A      |          5 mA       |
32 N 40 RU 12 P |       0...12 A      |       3.33 mA       |
32 N 80 RU  6 P |       0....6 A      |          2 mA       |
32 N 32 RU 18 P |       0...18 A      |          5 mA       |
62 N 40 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 40 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 40 RU100 P |       0..100 A      |         25 mA       |
64 N 40 RU150 P |       0..150 A      |         40 mA       |
62 N 80 RU12.5P |       0.12.5 A      |      3.125 mA       |
62 N 80 RU 25 P |       0...25 A      |       6.25 mA       |
64 N 80 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 80 RU 75 P |       0...75 A      |         20 mA       |
62 N 52 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 52 RU 50 P |       0...50 A      |      12.5  mA       |
64 N 52 RU 100P |       0..100 A      |         25 mA       |
64 N 52 RU 150P |       0..150 A      |         40 mA       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than current limit.    '    This control sets the setpoint value of the output voltage.

Default Value: 10.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (V)   |   Resolution (mV)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...20 V      |          5 mV       |
32 N 40 RU  6 P |       0...40 V      |         10 mV       |
32 N 80 RU  3 P |       0...80 V      |         20 mV       |
32 N 20 RU 20 P |       0...20 V      |          5 mV       |
32 N 40 RU 12 P |       0...40 V      |         10 mV       |
32 N 80 RU  6 P |       0...80 V      |         20 mV       |
32 N 32 RU 18 P |       0...32 V      |         10 mV       |
62 N 40 RU 25 P |       0...40 V      |         10 mV       |
62 N 40 RU 50 P |       0...40 V      |         10 mV       |
64 N 40 RU100 P |       0...40 V      |         10 mV       |
64 N 40 RU150 P |       0...40 V      |         10 mV       |
62 N 80 RU12.5P |       0...80 V      |         20 mV       |
62 N 80 RU 25 P |       0...80 V      |         20 mV       |
64 N 80 RU 50 P |       0...80 V      |         20 mV       |
64 N 80 RU 75 P |       0...80 V      |         20 mV       |
62 N 52 RU 25 P |       0...52 V      |         20 mV       |
62 N 52 RU 50 P |       0...52 V      |         20 mV       |
64 N 52 RU 100P |       0...52 V      |         20 mV       |
64 N 52 RU 150P |       0...52 V      |         20 mV       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than voltage limit.        This control defines the upper soft limit for the current setpoint, thus enabling you to prevent the output current from being set in excess of a certain value.

Default Value: 3.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (A)   |   Resolution (mA)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...10 A      |          1 mA       |
32 N 40 RU  6 P |       0....6 A      |          1 mA       |
32 N 80 RU  3 P |       0....3 A      |          1 mA       |
32 N 20 RU 20 P |       0...20 A      |          1 mA       |
32 N 40 RU 12 P |       0...12 A      |          1 mA       |
32 N 80 RU  6 P |       0....6 A      |          1 mA       |
32 N 32 RU 18 P |       0...18 A      |          1 mA       |
62 N 40 RU 25 P |       0...25 A      |          1 mA       |
62 N 40 RU 50 P |       0...50 A      |          1 mA       |
64 N 40 RU100 P |       0..100 A      |          1 mA       |
64 N 40 RU150 P |       0..150 A      |          1 mA       |
62 N 80 RU12.5P |       0.12.5 A      |          1 mA       |
62 N 80 RU 25 P |       0...25 A      |          1 mA       |
64 N 80 RU 50 P |       0...50 A      |          1 mA       |
64 N 80 RU 75 P |       0...75 A      |          1 mA       |
62 N 52 RU 25 P |       0...25 A      |          1 mA       |
62 N 52 RU 50 P |       0...50 A      |          1 mA       |
64 N 52 RU 100P |       0..100 A      |          1 mA       |
64 N 52 RU 150P |       0..150 A      |          1 mA       |
-------------------------------------------------------------

Note:
(1) Value must be larger than current setpoint.        This control defines the upper soft limit for the voltage setpoint, thus enabling you to prevent the output voltage from being set in excess of a certain value.

Default Value: 20.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (V)   |   Resolution (mV)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...20 V      |          1 mV       |
32 N 40 RU  6 P |       0...40 V      |          1 mV       |
32 N 80 RU  3 P |       0...80 V      |          1 mV       |
32 N 20 RU 20 P |       0...20 V      |          1 mV       |
32 N 40 RU 12 P |       0...40 V      |          1 mV       |
32 N 80 RU  6 P |       0...80 V      |          1 mV       |
32 N 32 RU 18 P |       0...32 V      |          1 mV       |
62 N 40 RU 25 P |       0...40 V      |          1 mV       |
62 N 40 RU 50 P |       0...40 V      |          1 mV       |
64 N 40 RU100 P |       0...40 V      |          1 mV       |
64 N 40 RU150 P |       0...40 V      |          1 mV       |
62 N 80 RU12.5P |       0...80 V      |          1 mV       |
62 N 80 RU 25 P |       0...80 V      |          1 mV       |
64 N 80 RU 50 P |       0...80 V      |          1 mV       |
64 N 80 RU 75 P |       0...80 V      |          1 mV       |
62 N 52 RU 25 P |       0...52 V      |          1 mV       |
62 N 52 RU 50 P |       0...52 V      |          1 mV       |
64 N 52 RU 100P |       0...52 V      |          1 mV       |
64 N 52 RU 150P |       0...52 V      |          1 mV       |
-------------------------------------------------------------

Note:
(1) Value must be larger than voltage setpoint.     D    This control returns output setpoint value of the output current.
     D    This control returns output setpoint value of the output voltage.
    8:      Status                            >         Instrument Handle                 ?H 2        Current Setting in A              Ev          Voltage Setting in V              K G2        Current Limit in A                R: G         Voltage Limit in V                X 2        Output Current in A               Y          Output Voltage in V                	               1.0    10.0    3.0    20.0    	           	           @    This function sets the setpoint value of the output voltage.

    _    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage Setting) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    *    This control sets the setpoint value of the output voltage.

Default Value: 0.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (V)   |   Resolution (mV)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...20 V      |          5 mV       |
32 N 40 RU  6 P |       0...40 V      |         10 mV       |
32 N 80 RU  3 P |       0...80 V      |         20 mV       |
32 N 20 RU 20 P |       0...20 V      |          5 mV       |
32 N 40 RU 12 P |       0...40 V      |         10 mV       |
32 N 80 RU  6 P |       0...80 V      |         20 mV       |
32 N 32 RU 18 P |       0...32 V      |         10 mV       |
62 N 40 RU 25 P |       0...40 V      |         10 mV       |
62 N 40 RU 50 P |       0...40 V      |         10 mV       |
64 N 40 RU100 P |       0...40 V      |         10 mV       |
64 N 40 RU150 P |       0...40 V      |         10 mV       |
62 N 80 RU12.5P |       0...80 V      |         20 mV       |
62 N 80 RU 25 P |       0...80 V      |         20 mV       |
64 N 80 RU 50 P |       0...80 V      |         20 mV       |
64 N 80 RU 75 P |       0...80 V      |         20 mV       |
62 N 52 RU 25 P |       0...52 V      |         20 mV       |
62 N 52 RU 50 P |       0...52 V      |         20 mV       |
64 N 52 RU 100P |       0...52 V      |         20 mV       |
64 N 52 RU 150P |       0...52 V      |         20 mV       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than the voltage limit.    [      Status                            a         Instrument Handle                 a G         Voltage Setting in V               	               0.0    B    This function queries the setpoint value of the output voltage.
    _    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage Setting) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     @    This control returns the setpoint value of the output voltage.    h      Status                            n=         Instrument Handle                 n G         Voltage Setting in V               	               	           F    This function defines the upper soft limit for the voltage setpoint.    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage Limit) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines the upper soft limit for the voltage setpoint, thus enabling you to prevent the output voltage from being set in excess of a certain value.

Default Value: 20.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (V)   |   Resolution (mV)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...20 V      |          1 mV       |
32 N 40 RU  6 P |       0...40 V      |          1 mV       |
32 N 80 RU  3 P |       0...80 V      |          1 mV       |
32 N 20 RU 20 P |       0...20 V      |          1 mV       |
32 N 40 RU 12 P |       0...40 V      |          1 mV       |
32 N 80 RU  6 P |       0...80 V      |          1 mV       |
32 N 32 RU 18 P |       0...32 V      |          1 mV       |
62 N 40 RU 25 P |       0...40 V      |          1 mV       |
62 N 40 RU 50 P |       0...40 V      |          1 mV       |
64 N 40 RU100 P |       0...40 V      |          1 mV       |
64 N 40 RU150 P |       0...40 V      |          1 mV       |
62 N 80 RU12.5P |       0...80 V      |          1 mV       |
62 N 80 RU 25 P |       0...80 V      |          1 mV       |
64 N 80 RU 50 P |       0...80 V      |          1 mV       |
64 N 80 RU 75 P |       0...80 V      |          1 mV       |
62 N 52 RU 25 P |       0...52 V      |          1 mV       |
62 N 52 RU 50 P |       0...52 V      |          1 mV       |
64 N 52 RU 100P |       0...52 V      |          1 mV       |
64 N 52 RU 150P |       0...52 V      |          1 mV       |
------------------------------------------------------------

Note:
(1) Value must be larger than voltage setpoint.    p-      Status                            u         Instrument Handle                 v1 G         Voltage Limit in V                 	               20.0    G    This function queries the upper soft limit for the voltage setpoint.
    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage Limit) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     E    This control returns the upper soft limit for the voltage setpoint.    }      Status                            1         Instrument Handle                  G         Voltage Limit in V                 	               	               This function defines Over Voltage Protection level. OVP Level defines the threshold value for the over voltage protection. As soon as the voltage at the output is automatically deactivated.
OVP response time is less than 200 micro seconds.
    Y    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (OVP Level) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines Over Voltage Protection level.


Default Value: 25.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (V)   |   Resolution (mV)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       3...25 V      |        100 mV       |
32 N 40 RU  6 P |       3...50 V      |        200 mV       |
32 N 80 RU  3 P |       3..100 V      |        400 mV       |
32 N 20 RU 20 P |       3...25 V      |        100 mV       |
32 N 40 RU 12 P |       3...50 V      |        200 mV       |
32 N 80 RU  6 P |       3..100 V      |        400 mV       |
32 N 32 RU 18 P |       3...40 V      |        200 mV       |
62 N 40 RU 25 P |       3...50 V      |        100 mV       |
62 N 40 RU 50 P |       3...50 V      |        100 mV       |
64 N 40 RU100 P |       3...50 V      |        100 mV       |
64 N 40 RU150 P |       3...50 V      |        100 mV       |
62 N 80 RU12.5P |       3..100 V      |        100 mV       |
62 N 80 RU 25 P |       3..100 V      |        100 mV       |
64 N 80 RU 50 P |       3..100 V      |        100 mV       |
64 N 80 RU 75 P |       3..100 V      |        100 mV       |
62 N 52 RU 25 P |       3...62.5 V    |        100 mV       |
62 N 52 RU 50 P |       3...62.5 V    |        100 mV       |
64 N 52 RU 100P |       3...62.5 V    |        100 mV       |
64 N 52 RU 150P |       3...62.5 V    |        100 mV       |
-------------------------------------------------------------
          Status                            4         Instrument Handle                  G         OVP Level in V                     	               25.0        This function queries Over Voltage Protection level. OVP Level defines the threshold value for the over voltage protection. As soon as the voltage at the output is automatically deactivated.
OVP response time is less than 200 micro seconds.
    Y    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (OVP Level) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     5    This control returns Over Voltage Protection level.    y      Status                                     Instrument Handle                 y G         OVP Level in V                     	               	           D    This function returns the upper voltage limit of the instrument.

    W    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     /    This control returns the upper voltage limit.          Status                                     Instrument Handle                  G         Max Voltage in V                   	               	           B    This function defines the setpoint value of the output current.
    _    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Current Setting) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    *    This control sets the setpoint value of the output current.

Default Value: 0.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (A)   |   Resolution (mA)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...10 A      |        2.5 mA       |
32 N 40 RU  6 P |       0....6 A      |          2 mA       |
32 N 80 RU  3 P |       0....3 A      |          1 mA       |
32 N 20 RU 20 P |       0...20 A      |          5 mA       |
32 N 40 RU 12 P |       0...12 A      |       3.33 mA       |
32 N 80 RU  6 P |       0....6 A      |          2 mA       |
32 N 32 RU 18 P |       0...18 A      |          5 mA       |
62 N 40 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 40 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 40 RU100 P |       0..100 A      |         25 mA       |
64 N 40 RU150 P |       0..150 A      |         40 mA       |
62 N 80 RU12.5P |       0.12.5 A      |      3.125 mA       |
62 N 80 RU 25 P |       0...25 A      |       6.25 mA       |
64 N 80 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 80 RU 75 P |       0...75 A      |         20 mA       |
62 N 52 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 52 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 52 RU 100P |       0..100 A      |         25 mA       |
64 N 52 RU 150P |       0..150 A      |         40 mA       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than the current limit.          Status                            ^         Instrument Handle                  G         Current Setting in A               	               0.0    B    This function queries the setpoint value of the output current.
    _    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Current Setting) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     A    This control returns the setpoint value of the output current.
    /      Status                                     Instrument Handle                 5 G         Current Settingin A                	               	           F    This function defines the upper soft limit for the current setpoint.    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Current Limit) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines the upper soft limit for the current setpoint, thus enabling you to prevent the output current from being set in excess of a certain value.

Default Value: 3.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (A)   |   Resolution (mA)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...10 A      |          1 mA       |
32 N 40 RU  6 P |       0....6 A      |          1 mA       |
32 N 80 RU  3 P |       0....3 A      |          1 mA       |
32 N 20 RU 20 P |       0...20 A      |          1 mA       |
32 N 40 RU 12 P |       0...12 A      |          1 mA       |
32 N 80 RU  6 P |       0....6 A      |          1 mA       |
32 N 32 RU 18 P |       0...18 A      |          1 mA       |
62 N 40 RU 25 P |       0...25 A      |          1 mA       |
62 N 40 RU 50 P |       0...50 A      |          1 mA       |
64 N 40 RU100 P |       0..100 A      |          1 mA       |
64 N 40 RU150 P |       0..150 A      |          1 mA       |
62 N 80 RU12.5P |       0.12.5 A      |          1 mA       |
62 N 80 RU 25 P |       0...25 A      |          1 mA       |
64 N 80 RU 50 P |       0...50 A      |          1 mA       |
64 N 80 RU 75 P |       0...75 A      |          1 mA       |
62 N 52 RU 25 P |       0...25 A      |          1 mA       |
62 N 52 RU 50 P |       0...50 A      |          1 mA       |
64 N 52 RU 100P |       0..100 A      |          1 mA       |
64 N 52 RU 150P |       0..150 A      |          1 mA       |
-------------------------------------------------------------

Note:
(1) Value must be larger than current setpoint.          Status                                     Instrument Handle                  G         Current Limit in A                 	               3.0    F    This function queries the upper soft limit for the current setpoint.    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Current Limit) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     E    This control returns the upper soft limit for the current setpoint.    $      Status                            ɉ         Instrument Handle                 ( G         Current Limit in A                 	               	          {    This function defines the OCP delay. Delay defines for the enabled OCP function (Set OCP State) the delay until the power output is OFF following a transition to current regulation (actual current = current setpoint) If the output current drops below the  setpoint value before timeout, the OFF sequence is interrupted and restarted when a return is made to current regulation.    a    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (OCP Delay in sec.) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     W    This control defines the OCP delay.

Default Value: 0.0

Valid Range: 0.0 s - 99.99 s    ̳      Status                                     Instrument Handle                 һ G         OCP Delay in sec                   	               0.0    &    This function queries the OCP delay.    `    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (OCP Delay in sec) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     %    This control returns the OCP delay.          Status                            f         Instrument Handle                  G         OCP Delay in sec                   	               	               This function selects OCP ON/OFF. The OCP function determines the behaviour of the power output when the load current reaches the setpoint value, i.e. when the output changes to the current regulation mode CC.    Y    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (OCP State) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     f    This control selects OCP ON/OFF.

Valid Range:
VI_FALSE (0) - Off (Default Value)
VI_TRUE  (1) - On           Status                            )         Instrument Handle                  G	        OCP State                          	               On VI_TRUE Off VI_FALSE        This function queries OCP state. The OCP function determines the behaviour of the power output when the load current reaches the setpoint value, i.e. when the output changes to the current regulation mode CC. 
    Y    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (OCP State) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     I    This control returns OCP state. 

VI_FALSE (0) - Off
VI_TRUE  (1) - On           Status                            =         Instrument Handle                  G         OCP State                          	               	            C    This function returns the upper current limit of the instrument.
    W    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     /    This control returns the upper current limit.    3      Status                                     Instrument Handle                 1 G         Max Current in A                   	               	           .    This function selects power output ON/OFF.

    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Output State) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control selects power output ON/OFF.

Valid Range:
VI_FALSE (0) - Off (Default Value)
VI_TRUE  (1) - On 

Note:
(1) Internal ON procedure: for the transition from inactive to active state the setpoints for current and voltage are first set "0" for an approx. 4 ms duration with the output active, after which the currently set values are executed.

(2) Internal OFF procedure: for approx. 350 ms the setpoint values for voltage and current are set to 0 V and 0 A respectively. During this period the sink is activated and the output capacitor will be discharged. The sink is then returned OFF so that the output becomes a high-impedance for externally
connected DC voltages (e.g. when outputs are paralleled) for values bellow the rated output voltage.    Y      Status                                     Instrument Handle                 \ G        Output State                       	               On VI_TRUE Off VI_FALSE    ,    This function queries power output state.
    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Output State) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     R    This control returns power output state.

VI_FALSE (0) - Off
VI_TRUE  (1) - On 
    Y      Status                                    Instrument Handle                \ G         Output State                       	               	           c    This function queries the current operating mode of the output.

Note:

(1) Under certain circumstances the instrument needs several seconds to fully switch among the output mode. If you find that the mode obtained using this function does not correspond to the instrument state, allow several seconds for the mode setling before calling this function.
    [    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Output Mode) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     ^    This control returns the actual operating mode of the output.

0 - OFF
1 - CV
2 - CC
3 - OL
         Status                           
?         Instrument Handle                
 G         Output Mode                        	               	            #    This function sets the Sequence.
    2    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Sequence State) out of range.
BFFC0003  Parameter 3 (Start Address) out of range.
BFFC0004  Parameter 4 (Stop Address) out of range.
BFFC0005  Parameter 5 (Sequence Repetition) out of range.
BFFC0006  Parameter 6 (Default Time) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines Sequence State. The Sequence function permits automatic recall of the values of voltage and current setpoint and sequence time saved in the memory locations 11 through 255 according to the parameters Sequence repetition, start and stop.

Valid Range:
VI_FALSE (0) - Off (Default Value)
VI_TRUE (1) - On

Note:
(1) Off - Terminate and/or close Sequence function

(2) On - Open Sequence function    9    This control defines Sequence Repetition. When the Sequence function is open, the Repetition parameter defines the number of times the sequence is to be repeated between the selected Start and Stop addresses.

Default Value: 0

Valid Range: 0 - 255

Note:
(1) 0 - infinite repetition

(2) 1-255 number of cycles        This control defines Start Index. The setting parameters Start memory location address and Stop memory location address define the beginning and end of the Sequence registers to be executed, whereby Stop address must be >= Start address.

Default Value: 11

Valid Range: 11 - 255        This control defines Stop Index. The setting parameters Start memory location address and Stop memory location address define the beginning and end of the Sequence registers to be executed, whereby Stop address must be >= Start address.

Default Value: 11

Valid Range: 11 - 255         This control defines Default Sequence Time. Default time defines the dwell default for a pair of voltage/current values to be output by the Sequence function.

Default Value: 0.01

Valid Range: 0.01s - 99.99s

Resolution: 0.01s   *      Status                           d         Instrument Handle                 G   `    Sequence State                             Sequence Repetition               G         Start Address                    
 G        Stop Address                     - +        Default Time in sec                	               On VI_TRUE Off VI_FALSE    0    11    11    0.01    )    This function sets the Sequence State.
    ^    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Sequence State) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines Sequence State. The Sequence function permits automatic recall of the values of voltage and current setpoint and sequence time saved in the memory locations 11 through 255 according to the parameters Sequence repetition, start and stop.

Valid Range:
VI_FALSE (0) - Off (Default Value)
VI_TRUE (1) - On

Note:
(1) Off - Terminate and/or close Sequence function

(2) On - Open Sequence function         Status                            h         Instrument Handle                ! G  `    Sequence State                     	               On VI_TRUE Off VI_FALSE    )    This function queries Sequence State.

    ^    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Sequence State) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     L    This control returns Sequence State.

VI_FALSE (0) - Off
VI_TRUE (1) - On
   #      Status                           )         Instrument Handle                ) G         Sequence State                     	               	            -    This function defines Sequence Repetition.
    c    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Sequence Repetition) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    9    This control defines Sequence Repetition. When the Sequence function is open, the Repetition parameter defines the number of times the sequence is to be repeated between the selected Start and Stop addresses.

Default Value: 0

Valid Range: 0 - 255

Note:
(1) 0 - infinite repetition

(2) 1-255 number of cycles   *      Status                           0^         Instrument Handle                0 G         Sequence Repetition                	               0    -    This function queries Sequence Repetition.
    c    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Sequence Repetition) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     +    This control returns Sequence Repetition.   3'      Status                           8         Instrument Handle                91 G         Sequence Repetition                	               	            (    This function defines Sequence Range.
        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Start Address) out of range.
BFFC0003  Parameter 3 (Stop Address) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines Start Index. The setting parameters Start memory location address and Stop memory location address define the beginning and end of the Sequence registers to be executed, whereby Stop address must be >= Start address.

Default Value: 11

Valid Range: 11 - 255        This control defines Stop Index. The setting parameters Start memory location address and Stop memory location address define the beginning and end of the Sequence registers to be executed, whereby Stop address must be >= Start address.

Default Value: 11

Valid Range: 11 - 255   :O      Status                           ?         Instrument Handle                @ G q        Start Address                    A G^        Stop Address                       	               11    11    )    This function queries Sequence Range.

        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Start Address) Null pointer.
BFFC0003  Parameter 3 (Stop Address) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     #    This control returns Start Index.     "    This control returns Stop Index.   C      Status                           I         Instrument Handle                J G q        Start Address                    JJ G^        Stop Address                       	               	            	            /    This function defines Default Sequence Time.
    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Default Time) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control defines Default Sequence Time. Default time defines the dwell default for a pair of voltage/current values to be output by the Sequence function.

Default Value: 0.01

Valid Range: 0.01s - 99.99s

Resolution: 0.01s   K      Status                           Q         Instrument Handle                Q G         Default Time in sec                	               0.01    .    This function queries Default Sequence Time.    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Default Time) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     -    This control returns Default Sequence Time.   S      Status                           X         Instrument Handle                Y G         Default Time in sec                	               	          5    This function defines Sequence Time. Sequence time represents the dwell time specific to each Sequence register for a pair of voltage/current values to be output by Sequence function. 
The sequence time gets saved into the register along with the voltage and current values with the function Save Register.
    Y    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Step Time) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control defines Sequence Time.

Default Value: 0.0

Valid Range: 0.00s - 99.99s

Resolution: 0.01s

Note:
(1) If the value is 0.0s, then Sequence time is the same as Default time.   [      Status                           a         Instrument Handle                a G         Step Time in sec                   	               0.0    '    This function queries Sequence Time.
    Y    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Step Time) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     %    This control returns Sequence Time.   c[      Status                           h         Instrument Handle                i[ G         Step Time in sec                   	               	               This function defines specific function for Signal1 and Signal2 outputs on Analog Interface. 

Note:
(1) This function is supported only by 32 X models.

        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Signal1) out of range.
BFFC0003  Parameter 3 (Signal2) out of range.
BFFC0004  Parameter 4 (State) out of range.
BFFC09F0  Instrument status error.
BFFC09F2  Function not supported for this model
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    z    This control defines specific function for Signal1 output on Analog Interface. 

Valid Range:
0 - Off (Default Value)
1 - On
2 - Out
3 - Mode
4 - Sequence
5 - Signal Set
6 - U Low
7 - U High
8 - I Low
9 - I High

Note:
(1) This function is supported only by 32 X models.

(2) Off - Signal1 passive high

(3) On - active low

(4) Out - Output On - passive high
          Output Off - active low

(5) Mode - Off to CV - passive high
           CC to OL - active low

(6) Sequence - Go - active low

(7) SignalSet - Off - passive high
                On - active low

(8) U Low - Umeas > Umin - passive high
            Umeas < Umin - active low

(9) U High - Umeas < Umax - passive high
             Umeas > Umax - active low

(10) I Low - Imeas > Imin - passive high
             Imeas < Imin - active low

(11) I High - Imeas < Imax - passive high
              Imeas > Imax - active low
    {    This control defines specific function for Signal2 output on Analog Interface. 

Valid Range:
0 - Off (Default Value)
1 - On
2 - Out
3 - Mode
4 - Sequence
5 - Signal Set
6 - U Low
7 - U High
8 - I Low
9 - I High

Note:
(1) This function is supported only by 32 X models.

(2) Off - Signal2 passive high

(3) On - active low

(4) Out - Output On - passive high
          Output Off - active low

(5) Mode - Off to CV - passive high
           CC to OL - active low

(6) Sequence - Go - active low

(7) SignalSet - Off - passive high
                On - active low

(8) U Low - Umeas > Umin - passive high
            Umeas < Umin - active low

(9) U High - Umeas < Umax - passive high
             Umeas > Umax - active low

(10) I Low - Imeas > Imin - passive high
             Imeas < Imin - active low

(11) I High - Imeas < Imax - passive high
              Imeas > Imax - active low

   j      Status                           p         Instrument Handle                qo G G       Signal 1                         t G        Signal 2                           	                       
   LOff 0 On 1 Out 2 Mode 3 Sequence 4 SSet 5 U Low 6 U High 7 I Low 8 I High 9            
   LOff 0 On 1 Out 2 Mode 3 Sequence 4 SSet 5 U Low 6 U High 7 I Low 8 I High 9        This function queries specific function for Signal1 and Signal2 outputs on Analog Interface.

Note:
(1) This function is supported only by 32 X models.
 

        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Signal1) Null pointer.
BFFC0003  Parameter 3 (Signal2) Null pointer.
BFFC0004  Parameter 4 (State) Null pointer.
BFFC09F0  Instrument status error.
BFFC09F2  Function not supported for this model
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control returns specific function for Signal1 output on Analog Interface. 

0 - Off
1 - On
2 - Out
3 - Mode
4 - Sequence
5 - Signal Set
6 - U Low
7 - U High
8 - I Low
9 - I High

Note:
(1) This function is supported only by 32 X models.
         This control returns specific function for Signal2 output on Analog Interface. 

0 - Off
1 - On
2 - Out
3 - Mode
4 - Sequence
5 - Signal Set
6 - U Low
7 - U High
8 - I Low
9 - I High

Note:
(1) This function is supported only by 32 X models.
   z      Status                                    Instrument Handle                ; G p        Signal 1                         7 G^        Signal 2                           	               	            	                This function defines Trigger Mode. The trigger mode determines the effect of the floating optocoupler input Trigger on the Analog Interface.
    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Trigger Mode) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines Trigger Mode.

Valid Range:
0 - Off (Default Value)
1 - Out
2 - Recall
3 - Sequence
4 - Local Locked
5 - MinMax Mode

Note:
(1) Off - Trigger input disabled

(2) Out - Trigger input controls Output On/Off
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          | Low     | Output state depends on       |
          |         | manual setting                |
          |Low->High| Output remains Off or         |
          |         | will be Off after 1..15ms     |
          | High    | Output is in Off state   and  |
          |         | cannot be activated manually  |
          |High->Low| Output will be activated      |
          |         | after 1..15ms                 |
          -------------------------------------------

(3) Recall - Trigger Input controls Recall of settings from Sequence memory in single step.
This trigger mode permits step-by-step execution of the Sequence function time controlled by an external signal. Each pulse (11ms<t<0.8s) applied to the trigger input causes the voltage/current pairs of an individual sequence register to be recalled, the sequence time parameter is of no consequences.
The first pulse applied after Trigger mode has been changed to Recall mode will recall Start register.
Applying a pulse with t>1.0s will reset the counter for register number and another pulse will recall the Start register.

(4) Sequence - Trigger input controls execution of the sequence functions
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          |Low->High| 1 to 15 ms later the Sequence |
          |         | execution is started (Seq Go) |
          |High->Low| 1 to 15 ms later the Sequence |
          |         | is discontinued (Seq Stop)    |
          -------------------------------------------

(5) Local Locked - Trigger input controls locking of front panel controls
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          | Low     | all front panel controls are  |
          |         | enabled                       |
          | High    | all front panel controls are  |
          |         | disabled                      |
          -------------------------------------------

(6) MinMax - Trigger input controls MinMax function
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          | Low     | Minmax state depends on       |
          |         | manual setting                |
          |Low->High| MinMax reset is executed      |
          | High    | MinMax On                     |
          |High->Low| MinMax Off                    |
          -------------------------------------------

         Status                           +         Instrument Handle                 G        Trigger Mode                       	                          8Off 0 Out 1 Recall 2 Sequence 3 Local Locked 4 MinMax 5    &    This function returns Trigger Mode.
    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Trigger Mode) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    7    This control returns Trigger Mode. The trigger mode determines the effect of the floating optocoupler input Trigger on the Analog Interface.

0 - Off
1 - Out
2 - Recall
3 - Sequence
4 - Local Locked
5 - MinMax Mode

Note:
(1) Off - Trigger input disabled

(2) Out - Trigger input controls Output On/Off
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          | Low     | Output state depends on       |
          |         | manual setting                |
          |Low->High| Output remains Off or         |
          |         | will be Off after 1..15ms     |
          | High    | Output is in Off state   and  |
          |         | cannot be activated manually  |
          |High->Low| Output will be activated      |
          |         | after 1..15ms                 |
          -------------------------------------------

(3) Recall - Trigger Input controls Recall of settings from Sequence memory in single step.
This trigger mode permits step-by-step execution of the Sequence function time controlled by an external signal. Each pulse (11ms<t<0.8s) applied to the trigger input causes the voltage/current pairs of an individual sequence register to be recalled, the sequence time parameter is of no consequences.
The first pulse applied after Trigger mode has been changed to Recall mode will recall Start register.
Applying a pulse with t>1.0s will reset the counter for register number and another pulse will recall the Start register.

(4) Sequence - Trigger input controls execution of the sequence functions
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          |Low->High| 1 to 15 ms later the Sequence |
          |         | execution is started (Seq Go) |
          |High->Low| 1 to 15 ms later the Sequence |
          |         | is discontinued (Seq Stop)    |
          -------------------------------------------

(5) Local Locked - Trigger input controls locking of front panel controls
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          | Low     | all front panel controls are  |
          |         | enabled                       |
          | High    | all front panel controls are  |
          |         | disabled                      |
          -------------------------------------------

(6) MinMax - Trigger input controls MinMax function
          -------------------------------------------
          | Trigger | Effect                        |
          -------------------------------------------
          | Low     | Minmax state depends on       |
          |         | manual setting                |
          |Low->High| MinMax reset is executed      |
          | High    | MinMax On                     |
          |High->Low| MinMax Off                    |
          -------------------------------------------

         Status                           D         Instrument Handle                 G         Trigger Mode                       	               	                This function sets Signal Set (SSet) functionallity in the instrument.

Note:
(1) This function is supported only by 32 X models.

    T    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (SSet) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control defines the Signal1 and Signal2 Output state.

Valid Range:
VI_FALSE (0) - Off (Default Value)
VI_TRUE (1) - On

Note:
(1) This function is supported only by 32 X models.
   j      Status                                    Instrument Handle                e P        SSet                               	               On VI_TRUE Off VI_FALSE        This function gets Signal Set (SSet) functionallity in the instrument.

Note:
(1) This function is supported only by 32 X models.

    T    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (SSet) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control returns the Signal1 and Signal2 Output state.

VI_FALSE (0) - Off 
VI_TRUE (1) - On

Note:
(1) This function is supported only by 32 X models.
   ~      Status                                    Instrument Handle                y F         SSet                               	               	               This function selects MINMAX mode.

Notes:

(1) The MINMAX function allows the MIN and MAX values of voltage and current to be saved in memory.

(2) Resetting the saved MINMAX values is possible at any time by Reset MinMax function in Action/Status functions.    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (MinMax State) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     i    This control selects MINMAX mode.

Valid Range:
VI_FALSE (0) - Off (Default Value)
VI_TRUE  (1) - On 

         Status                           K         Instrument Handle                 G	       MinMax State                       	               On VI_TRUE Off VI_FALSE    $    This function queries MINMAX mode.    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (MinMax State) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control returns MINMAX mode. The MINMAX function allows the MIN and MAX values of voltage and current to be saved in memory.

VI_FALSE (0) - Off
VI_TRUE  (1) - On   Q      Status                           ȵ         Instrument Handle                T G         MinMax State                       	               	            J    This function defines the status of the device setting after power on.

    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Power-On Mode) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    E    This control defines the status of the device setting after power on.

Valid Range:
0 - Reset (Default Value)
1 - Recall
2 - Stand-by

Note:
(1) Reset - Device returns to default setting.

(2) Recall - Device settings are the same as before power-off.

(3) Stand-by - Same as for Recall except that power output remains OFF         Status                           w         Instrument Handle                 G        Power-On Mode                      	                          Reset 0 Recall 1 Stand By 2    J    This function queries the status of the device setting after power on.

    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Power-On Mode) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     j    This control returns the status of the device setting after power on.

0 - Reset
1 - Recall
2 - Stand-by   ӏ      Status                                    Instrument Handle                ٓ G         Power-On Mode                      	               	            /    This function operates the sequence trigger.
    `    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Sequence Control) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines Sequence Trigger. 

Valid Range:

For 62 X,64 X models:
0 - Go (Default Value)

For 32 X models:
0 - Go (Default Value)
1 - Hold
2 - Cont
3 - Start
4 - Step
5 - Stop

Note:
(1) Go - Start Sequence

(2) Hold - Pause Sequence (Firmware rev. 1.003 only)

(3) Cont - Continue Sequence (Firmware rev. 1.003 only)

(4) Start - Recall Start Register parameters

(5) Step - Recall next register parameters

(6) Stop - Recall Stop register parameters         Status                           _         Instrument Handle                 G        Sequence Control                   	                          )Go 0 Hold 1 Cont 2 Start 3 Step 4 Stop 5    0    This function resets values in MinMax memory.
    )    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         Status                           &         Instrument Handle                  	                   This function returns the limit values of the output current and voltage measured and saved in MINMAX memory during MINMAX ON.    )    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This function returns the minimum value of the output current measured and saved in MINMAX memory during MINMAX ON.

Note:

(1) You may pass VI_NULL if you do not need this value.         This function returns the maximum value of the output current measured and saved in MINMAX memory during MINMAX ON.

Note:

(1) You may pass VI_NULL if you do not need this value.         This control returns the minimum value of the output voltage measured and saved in MINMAX memory during MINMAX ON.

Note:

(1) You may pass VI_NULL if you do not need this value.         This function returns the maximum value of the output voltage measured and saved in MINMAX memory during MINMAX ON.

Note:

(1) You may pass VI_NULL if you do not need this value.         Status                                    Instrument Handle                  u        Min Current in A                 T Y        Max Current in A                  = u        Min Voltage in V                  =Y        Max Voltage in V                   	               	           	           	           	           J    This function queries the actual measured value of the output voltage.

    ^    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Output Voltage) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     H    This control returns the actual measured value of the output voltage.
   Z      Status                                    Instrument Handle                _ G         Output Voltage                     	               	           I    This function queries the actual measured value of the output current.
    ^    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Output Current) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     H    This control returns the actual measured value of the output current.
         Status                           !         Instrument Handle                 G         Output Current                     	               	               This function queries the actually measured power on the output.
The time required to acquire and process the reading is approx. 90 ms.
    \    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Output Power) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     B    This control returns the actually measured power on the output.
   ]      Status                           	         Instrument Handle                
` G         Output Power in W                  	               	           M    This function recalls the specified register from the instrument's memory.
    b    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Recall Register No) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines the register to recall.

Default Value: 1

Valid Range: 1 - 255

Note:
(1) 1 - 10 Recalled parameters USET, ISET, OVSET, ULIM, ILIM,
           OUTPUT Mode, OCP State, OCP Delay, MinMax Mode State,
           Sequence Mode, Seq. Time, Seq. Default Time, Seq.         
           Repetition, Seq. Start, Seq. Stop

(2) 11 - 255 Recalled parameters USET, ISET, Seq. Time         Status                           $         Instrument Handle                 G         Recall Register No                 	               1    G    This function stores settings to the register in instrument's memory.    `    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Save Register No) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control defines the register to store settings to it.

Default Value: 1

Valid Range: 1 - 255

Note:
(1) 1 - 10 Saved parameters USET, ISET, OVSET, ULIM, ILIM,
           OUTPUT Mode, OCP State, OCP Delay, MinMax Mode State,
           Sequence Mode, Seq. Time, Seq. Default Time, Seq.         
           Repetition, Seq. Start, Seq. Stop

(2) 11 - 255 Saved parameters USET, ISET, Seq. Time   U      Status                                    Instrument Handle                \ G         Save Register No                   	               1    k    This function stores parameters to register.

Note:
(1) This function is supported only by 32 X models.

    R    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Register No) out of range.
BFFC0003  Parameter 3 (Voltage Setting) out of range.
BFFC0004  Parameter 4 (Current Setting) out of range.
BFFC0005  Parameter 5 (Step Time) out of range.
BFFC0006  Parameter 6 (SSet) out of range.
BFFC09F0  Instrument status error.
BFFC09F2  Function not supported for this model
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control defines the register to store settings to it.

Default Value: 11

Valid Range: 11 - 255

Note:
(1) This function is supported only by 32 X models.

    &    This control sets the setpoint value of the output voltage.

Default Value: 0.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (V)   |   Resolution (mV)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...20 V      |          5 mV       |
32 N 40 RU  6 P |       0...40 V      |         10 mV       |
32 N 80 RU  3 P |       0...80 V      |         20 mV       |
32 N 20 RU 20 P |       0...20 V      |          5 mV       |
32 N 40 RU 12 P |       0...40 V      |         10 mV       |
32 N 80 RU  6 P |       0...80 V      |         20 mV       |
32 N 32 RU 18 P |       0...32 V      |         10 mV       |
62 N 40 RU 25 P |       0...40 V      |         10 mV       |
62 N 40 RU 50 P |       0...40 V      |         10 mV       |
64 N 40 RU100 P |       0...40 V      |         10 mV       |
64 N 40 RU150 P |       0...40 V      |         10 mV       |
62 N 80 RU12.5P |       0...80 V      |         20 mV       |
62 N 80 RU 25 P |       0...80 V      |         20 mV       |
64 N 80 RU 50 P |       0...80 V      |         20 mV       |
64 N 80 RU 75 P |       0...80 V      |         20 mV       |
62 N 52 RU 25 P |       0...52 V      |         20 mV       |
62 N 52 RU 50 P |       0...52 V      |         20 mV       |
64 N 52 RU 100P |       0...52 V      |         20 mV       |
64 N 52 RU 150P |       0...52 V      |         20 mV       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than voltage limit.    &    This control sets the setpoint value of the output current.

Default Value: 0.0

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (A)   |   Resolution (mA)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...10 A      |        2.5 mA       |
32 N 40 RU  6 P |       0....6 A      |          2 mA       |
32 N 80 RU  3 P |       0....3 A      |          1 mA       |
32 N 20 RU 20 P |       0...20 A      |          5 mA       |
32 N 40 RU 12 P |       0...12 A      |       3.33 mA       |
32 N 80 RU  6 P |       0....6 A      |          2 mA       |
32 N 32 RU 18 P |       0...18 A      |          5 mA       |
62 N 40 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 40 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 40 RU100 P |       0..100 A      |         25 mA       |
64 N 40 RU150 P |       0..150 A      |         40 mA       |
62 N 80 RU12.5P |       0.12.5 A      |      3.125 mA       |
62 N 80 RU 25 P |       0...25 A      |       6.25 mA       |
64 N 80 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 80 RU 75 P |       0...75 A      |         20 mA       |
62 N 52 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 52 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 52 RU 100P |       0..100 A      |         25 mA       |
64 N 52 RU 150P |       0..150 A      |         40 mA       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than current limit.    J    This control defines Sequence Time. Sequence time defines the dwell time specific to each Sequence register for a pair of voltage/current values to be output by Sequence function.

Default Value: 0.0

Valid Range: 0.00s - 99.99s

Resolution: 0.01s

Note:
(1) If the value is 0.0s, then Sequence time is the same as Default time.         This control defines the state of selected register.

Valid Range:
0 - Off
1 - On (Default Value)
2 - Clear

Note:
(1) Off - Register is disabled.

(2) On - Register is enabled.

(3) Clear - Register is cleared.         Status                           #t         Instrument Handle                $ G 0        Register No                      $ G         Voltage Setting in V             * G        Current Setting in A             1  0        Step Time in sec                 2l         SSet                               	               11    0.0    0.0    0.0              Off 0 On 1 Clear 2    l    This function returns parameters to register.

Note:
(1) This function is supported only by 32 X models.

    R    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Register No) out of range.
BFFC0003  Parameter 3 (Voltage Setting) out of range.
BFFC0004  Parameter 4 (Current Setting) out of range.
BFFC0005  Parameter 5 (Step Time) out of range.
BFFC0006  Parameter 6 (SSet) out of range.
BFFC09F0  Instrument status error.
BFFC09F2  Function not supported for this model
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control defines the register to read settings.

Default Value: 11

Valid Range: 11 - 255

Note:
(1) This function is supported only by 32 X models.

     @    This control returns the setpoint value of the output voltage.     @    This control returns the setpoint value of the output current.         This control returns Sequence Time. Sequence time defines the dwell time specific to each Sequence register for a pair of voltage/current values to be output by Sequence function.         This control returns the state of selected register.

Valid Range:
0 : Off - Register is disabled.
1 : On  - Register is enabled.
2 : Clear - Register is cleared.
   5}      Status                           ;         Instrument Handle                <v G 0        Register No                      = G         Voltage Setting in V             =b G        Current Settingin A              =  0        Step Time in sec                 >g         SSet                               	               11    	           	           	           	            q    This function stores parameters to more registers.

Note:
(1) This function is supported only by 32 X models.

        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Register No) out of range.
BFFC0003  Parameter 3 (Voltage Setting) Null pointer.
BFFC0004  Parameter 4 (Current Setting) Null pointer.
BFFC0005  Parameter 5 (Step Time) Null pointer.
BFFC0006  Parameter 6 (SSet) Null pointer.
BFFC0007  Parameter 7 (Number of points) out of range.
BFFC09F0  Instrument status error.
BFFC09F2  Function not supported for this model
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control defines first register to start store settings to memory from it.

Default Value: 11

Valid Range: 11 - 255

Note:
(1) This function is supported only by 32 X models.

    4    This control sets array of setpoint values of the output voltage.

Default Value: not defined

Valid Range:
-------------------------------------------------------------
Model           |   Valid Range (V)   |   Resolution (mV)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...20 V      |          5 mV       |
32 N 40 RU  6 P |       0...40 V      |         10 mV       |
32 N 80 RU  3 P |       0...80 V      |         20 mV       |
32 N 20 RU 20 P |       0...20 V      |          5 mV       |
32 N 40 RU 12 P |       0...40 V      |         10 mV       |
32 N 80 RU  6 P |       0...80 V      |         20 mV       |
32 N 32 RU 18 P |       0...32 V      |         10 mV       |
62 N 40 RU 25 P |       0...40 V      |         10 mV       |
62 N 40 RU 50 P |       0...40 V      |         10 mV       |
64 N 40 RU100 P |       0...40 V      |         10 mV       |
64 N 40 RU150 P |       0...40 V      |         10 mV       |
62 N 80 RU12.5P |       0...80 V      |         20 mV       |
62 N 80 RU 25 P |       0...80 V      |         20 mV       |
64 N 80 RU 50 P |       0...80 V      |         20 mV       |
64 N 80 RU 75 P |       0...80 V      |         20 mV       |
62 N 52 RU 25 P |       0...52 V      |         20 mV       |
62 N 52 RU 50 P |       0...52 V      |         20 mV       |
64 N 52 RU 100P |       0...52 V      |         20 mV       |
64 N 52 RU 150P |       0...52 V      |         20 mV       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than voltage limit.    J    This control sets the array of setpoint values of the output current.

Default Value: not defined

Valid Range of array elements:
-------------------------------------------------------------
Model           |   Valid Range (A)   |   Resolution (mA)   |
-------------------------------------------------------------
32 N 20 RU 10 P |       0...10 A      |        2.5 mA       |
32 N 40 RU  6 P |       0....6 A      |          2 mA       |
32 N 80 RU  3 P |       0....3 A      |          1 mA       |
32 N 20 RU 20 P |       0...20 A      |          5 mA       |
32 N 40 RU 12 P |       0...12 A      |       3.33 mA       |
32 N 80 RU  6 P |       0....6 A      |          2 mA       |
32 N 32 RU 18 P |       0...18 A      |          5 mA       |
62 N 40 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 40 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 40 RU100 P |       0..100 A      |         25 mA       |
64 N 40 RU150 P |       0..150 A      |         40 mA       |
62 N 80 RU12.5P |       0.12.5 A      |      3.125 mA       |
62 N 80 RU 25 P |       0...25 A      |       6.25 mA       |
64 N 80 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 80 RU 75 P |       0...75 A      |         20 mA       |
62 N 52 RU 25 P |       0...25 A      |       6.25 mA       |
62 N 52 RU 50 P |       0...50 A      |       12.5 mA       |
64 N 52 RU 100P |       0..100 A      |         25 mA       |
64 N 52 RU 150P |       0..150 A      |         40 mA       |
-------------------------------------------------------------

Note:
(1) Value must be smaller than current limit.    ]    This control sets the array of Sequence Times. Sequence time defines the dwell time specific to each Sequence register for a pair of voltage/current values to be output by Sequence function.

Default Value: not defined

Valid Range: 0.00s - 99.99s

Resolution: 0.01s

Note:
(1) If the value is 0.0s, then Sequence time is the same as Default time.         This control defines array of states of selected registers.

Valid Range:
0 - Off
1 - On (Default Value)
2 - Clear

Note:
(1) Off - Register is disabled.

(2) On - Register is enabled.

(3) Clear - Register is cleared.     u    This control defines the number of points to store in registers.

Default Value: not defined

Valid Range: 0 to 245   AF      Status                           G         Instrument Handle                Hv G 0        Start Register No                I5 G         Voltage Setting in V             Oq G        Current Setting in A             U  0        Step Time in sec                 W(         SSet                             X         Number Of Elements                 	               11                        1    This function sets specified value to register.        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (System Register No) out of range.
BFFC0003  Parameter 3 (Voltage) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     _    Register name to set.

Valid Range:
0 - ESE (Default Value)
1 - ERAE
2 - ERBE
4 - SRE
5 - PRE     D    New value of the register.

Valid Range: 0 - 255

Default Value: 0   Z      Status                           `,         Instrument Handle                ` G d       System Register Name             a2 GJ        Value                              	                           ESE 0 ERAE 1 ERBE 2 SRE 3 PRE 4    0    3    This function gets specified value from register.        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Register No) out of range.
BFFC0003  Parameter 3 (Voltage) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         Register name to get.

Valid Range:
0 - ESR (Default Value)
1 - ESE
2 - CRA
3 - ERA
4 - ERAE
5 - ERB
6 - ERBE
7 - STB
8 - SRE
9 - PRE         Value of the register.   b      Status                           hb         Instrument Handle                i G d       Register Name                    i GJ        Value                              	                       
   >ESR 0 ESE 1 CRA 2 ERA 3 ERAE 4 ERB 5 ERBE 6 STB 7 SRE 8 PRE 9    	           U    This function switches ON/OFF state checking of the instrument (reading of the Standard Event Register and checking it for error). 
All driver functions are using state checking. Set this function to ON when debugging your application. For better bus throughput and instrument performance switch it OFF. 

State checking is ON by default.
    U    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (State) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control selects ON or OFF instrument state checking.

Valid Range:
VI_FALSE (0) - Off
VI_TRUE  (1) - On (Default Value)
   lJ      Status                           q         Instrument Handle                rF G	        State                              	              On VI_TRUE Off VI_FALSE    m    This function writes commands and queries to the instrument to modify parameters and query device settings.    c    The user can use this control to send common commands and queries to the instrument. This control can also be used to write any valid command to the instrument.

Default Value:  "*RST"

Notes:

(1) The command or query to be sent to the instrument may be a literal enclosed in double quotes i.e. "*RST" or may be contained in a variable of type string.
        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:

BFFC09F0  Instrument status error.
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   t G K      Write Buffer                     uw      Status                           z         Instrument Handle                  "*RST"    	              7    This function reads data from the instrument's output buffer and returns it to the specified variable in memory.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) If valid data is not available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled this function will hang indefinitely and it may be necessary to reboot the computer to break out.        The number of bytes specified by this control should be greater than or equal to the number of bytes which are to be read from the instrument. If the actual number of bytes to be read is greater than the number this control specifies then multiple reads will be required to empty the instrument's output buffer.

If the instrument's output buffer is not emptied the instrument may return invalid data when future reads are performed.

Default Value:  50 (See NOTE 2)

Notes:

(1) If NO DATA is available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled, this function will hang indefinitely and it may be necessary to reboot the computer.

(2) If the number of bytes expected is greater than 50 the value of this control may be increased. If the actual number of bytes read is larger than the declared size of the read buffer a run-time error will be generated.
        The incoming data from the instrument is placed into this variable.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) This function does not overwrite any old data left in the string variable from the last time the function was called. String data in LabWindows/CVI is terminated with an ASCII null(0x0) and string manipulation functions will only recognize data before the ASCII null.

(3) The declared size of the string variable must be greater than the actual number of bytes read from the instrument if it is not a run-time error will be generated.
        This variable contains the actual number of bytes read from the instrument. This is the value which is returned by the read function.

Notes:

(1) If the actual number of bytes read is less than the number of bytes specified in the Number Bytes To Read control then the output buffer has probably been emptied. If the read function fails and the number of bytes read is 0, the most probable cause for the failure is there was no data available at the instrument's output buffer.        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
BFFC09F0  Instrument status error.

Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   } G K        Number Bytes To Read               H      Read Buffer                      / Gx        NumBytes Read                          Status                                    Instrument Handle                  50    	            	            	                   This function resets the instrument to a known state and sends initialization commands to the instrument that set any necessary programmatic variables.    B    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC09F0  Instrument status error.
BFFC09F1  Unknown instrument model

This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   2      Status                           |         Instrument Handle                  	               X    This function runs the instrument's self test routine and returns the test result(s).
         This control contains the value returned from the instrument self test.  Zero means success.  For any other code, see the device's operator's manual.
         This control contains the string returned from the self test. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].    y    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST

BFFC0002  Parameter 2 (Self-Test Result) NULL pointer.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    G 2        Self Test Result                  G   ,    Self-Test Message                r      Status                                    Instrument Handle                  	           	            	                   This function runs a set of the instrument's internal diagnostic routines and returns the results. 

Note:
(1) This function is supported only by 62 X and 64 X models.


         This control contains the string returned from the diagnostics. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].    m    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Self-Test Result) NULL pointer.
BFFC09F2  Function not supported for this model
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   B G       Diagnostics Message              !      Status                                    Instrument Handle                  	            	               G    This function reads an error code from the instrument's error queue.
     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
3FFC0104  Error query not supported

BFFC0002  Parameter 2 (Error Code) NULL pointer.
BFFC0003  Parameter 3 (Error Message) NULL pointer.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   ? G 2        Error Code                        G   ,    Error Message                    C      Status                                    Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].    =    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
3FFF0085  Unknown status code - VI_WARN_UNKNOWN_STATUS
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL   	 G         Status Code                       G       Message                          )      Status                           n         Instrument Handle                  0    	            	           VI_NULL   d    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user with which  instrument firmware this revision of the driver is compatible. 

This instrument driver's Revision Number is 
"Rev 1.1, 07/2000, CVI 5.5" and is compatible with Instrument Firmware Revision "1.002" for 32 X model and "2.012" for 62 X and 64 X model.

This instrument driver was developed using instruments returning the following identification strings:

model 32 X:
GOSSEN-METRAWATT,SSP32N040RU012P,000000000,01.002

model 62 X and 64 X:
GOSSEN-METRAWATT,62N080RU025P,ET 0003  ,02.012
         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].    <    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
3FFC0105  Revision query not supported - VI_WARN_NSUP_REV_QUERY

This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   x G 2       Instrument Driver Revision        G^       Firmware Revision                      Status                                    Instrument Handle                  	            	            	                   This function selects display mode. This function enables the digital display to be signalled OFF if remote control is active.
    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Display State) out of range.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     s    This control lock/unlock the instrument.

Valid Range:
VI_FALSE (0) - Unlock
VI_TRUE  (1) - Lock  (Default Value)         Status                           Z         Instrument Handle                 G	        Display State                      	              On VI_TRUE Off VI_FALSE    %    This function queries display mode.    ]    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Display State) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     N    This control returns display mode.

VI_FALSE (0) - Off 
VI_TRUE  (1) - On 

   k      Status                                    Instrument Handle                o G         Display State                      	               	            H    This function returns the instrument model as a string and a number.

    W    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Voltage) Null pointer.
BFFC09F0  Instrument status error.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control returns the instrument model as a number. You can pass VI_NULL if you don't need to know this number.

Return Values:

0 - 32N020RU010
1 - 32N040RU006
2 - 32N080RU003
3 - 32N020RU020
4 - 32N040RU012
5 - 32N080RU006
6 - 32N032RU018
7 - 62N040RU025
8 - 62N040RU050
9 - 64N040RU100
10 - 64N040RU150
11 - 62N080RU125
12 - 62N080RU025
13 - 64N080RU050
14 - 64N080RU075
15 - 62N052RU025
16 - 62N052RU050
17 - 64N052RU100
18 - 64N052RU150
     z    This control returns the Instrument Model string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         Status                           /         Instrument Handle                          Instr Model Number               ו G        Instrument Model                   	               	            	            ;    This function defines the delay between I/O operations.

    :    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (IO Delay Time) out of range.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     s    This value specifies the delay between I/O operations.

Valid Range: => 0.0 seconds

Default Value: 0.002 seconds   V      Status                           ޘ         Instrument Handle                7 G         IO Delay Time                      	               0.002    H    This function returns the instrument model as a string and a number.

    :    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (IO Delay Time) Null pointer.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     8    This control returns the delay between I/O operations.         Status                                    Instrument Handle                 G    `    IO Delay Time                      	               	               This function address the appropriate instrument when several instruments are chained via serial cable.

Note:
(1) This function is supported only by 32 X models.
(2) This function is supported only via serial interface.    B    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Address Of Instrument) out of range.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     ^    Address of the instrument in the serial cable chain.

Default Value: 11

Valid Range: 1 - 32   |      Status                                    Instrument Handle                e =         Address Of Instrument              	               11        This function locks/unlocks the instrument.

Note:
(1) This function is supported only via GPIB interface.
(2) You have to have NI-VISA version 2.01 or greather properly installed on your machine.    7    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the rsamiq_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This driver defines the following status codes:
          
Status    Description
-------------------------------------------------
BFFC0002  Parameter 2 (Instrument) out of range.
          
This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     t    This control lock/unlock the instrument.

Valid Range:
VI_FALSE (0) - Unlock
VI_TRUE  (1) - Lock  (Default Value)
   N      Status                                    Instrument Handle                , G         Instrument                         	              Lock VI_TRUE Unlock VI_FALSE        This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.    x    Returns the status code of this operation. The status code  either indicates success or describes an error or warning condition. You examine the status code from each call to an instrument driver function to determine if an error occurred. To obtain a text description of the status code, call the gmsspx_error_message function.
          
The general meaning of the status code is as follows:

Value                  Meaning
-------------------------------
0                      Success
Positive Values        Warnings
Negative Values        Errors

This instrument driver also returns errors and warnings defined by other sources. The following table defines the ranges of additional status codes that this driver can return. The table lists the different include files that contain the defined constants for the particular status codes:
          
Numeric Range (in Hex)   Status Code Types    
-------------------------------------------------
3FFF0000 to 3FFFFFFF     VISA     Warnings
3FFC0000 to 3FFCFFFF     VXIPnP   Driver Warnings
          
BFFF0000 to BFFFFFFF     VISA     Errors
BFFC0000 to BFFCFFFF     VXIPnP   Driver Errors
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   $      Status                                    Instrument Handle                  	                     $  6O     K.    init                                     7  Yh     K.    AppExample                               [V  g     K.    confSetVolt                              h  o$     K.    confGetVolt                              o  |     K.    confSetVoltLimit                         }}       K.    confGetVoltLimit                                K.    confSetOVPLevel                          ~       K.    confGetOVPLevel                          q       K.    confGetVoltMax                             /     K.    confSetCurrent                             ~     K.    confGetCurrent                           9        K.    confSetCurrLimit                           u     K.    confGetCurrLimit                         0       K.    confSetOCPDelay                            2     K.    confGetOCPDelay                            6     K.    confSetOCPState                             -     K.    confGetOCPState                            h     K.    confGetCurrMax                           #  [     K.    confSetOutputState                       %      K.    confGetOutputState                      q D     K.    confGetOutputMode                             K.    confSetSeq                               "     K.    confSetSeqState                         #y *     K.    confGetSeqState                         * 2>     K.    confSetSeqRepetition                    2 9d     K.    confGetSeqRepetition                    : B     K.    confSetSeqRange                         C Jt     K.    confGetSeqRange                         Kp R     K.    confSetSeqDefaultTime                   SN Y     K.    confGetSeqDefaultTime                   Zw bv     K.    confSetSeqTime                          c, i     K.    confGetSeqTime                          jC xt     K.    confSetSignalFunc                       z 3     K.    confGetSignalFunc                       /      K.    confSetTriggerMode                       "     K.    confGetTriggerMode                       '     K.    confSetSset                                   K.    confGetSset                              [     K.    confSetMinMaxState                      %      K.    confGetMinMaxState                       c     K.    confSetPwrOnMode                        =      K.    confGetPwrOnMode                              K.    actSendSeqTrigger                             K.    resetMinMax                             ?      K.    fetchMinMax                                   K.    measOutVolt                             j      K.    measOutCurr                              
     K.    measOutPower                            e R     K.    dataRecallRegister                            K.    dataSaveRegister                         3I     K.    dataStoreReg                            5	 ?     K.    dataReadReg                             @ X     K.    dataStoreRegDataArr                     Z[ a~     K.    utilSetReg                              b i     K.    utilGetReg                              j r     K.    errorCheckState                         s z     K.    writeInstrData                          {s Z     K.    readInstrData                                 K.    reset                                         K.    self_test                                5     K.    diag                                     z     K.    error_query                             v      K.    error_message                            p     K.    revision_query                          l t     K.    utilSetDisplayState                     >      K.    utilGetDisplayState                     π      K.    utilGetInstrModel                        ߲     K.    utilSetIODelay                          j      K.    utilGetIODelay                                K.    utilAddress                                   K.    utilLockInstr                           w C     K.    close                                 t                                     DInitialize                          Function Examples                    DApplication Example                 Configuration Functions             
2Voltage Configuration                DSet Voltage Setting                  DGet Voltage Setting                  DSet Voltage Limit                    DGet Voltage Limit                    DSet OVP Level                        DGet OVP Level                        DGet Max Voltage                     Current Configuration                DSet Current Setting                  DGet Current Setting                  DSet Current Limit                    DGet Current Limit                    DSet OCP Delay                        DGet OCP Delay                        DSet OCP State                        DGet OCP State                        DGet Max Current                     Output Configuration                 DSet Output State                     DGet Output State                     DGet Output Mode                     Sequence Configuration               DSequence Setting                     DSet Sequence State                   DGet Sequence State                   DSet Sequence Repetition              DGet Sequence Repetition              DSet Sequence Start Stop Address      DGet Sequence Start Stop Address      DSet Sequence Default Time            DGet Sequence Default Time            DSet Sequence Step Time               DGet Sequence Step Time              Analog Interface Configuration       DSet Sig1_Sig2                        DGet Sig1_Sig2                        DSet Trigger Mode                     DGet Trigger Mode                     DSet Sset                             DGet Sset                            iMinMax Configuration                 DSet MinMax State                     DGet MinMax State                     DSet Power-On Mode                    DGet Power-On Mode                   "Action/Status Functions              DSequence Control                     DReset MinMax                        fData Functions                      XMeasurement Functions                DFetch Min Max Measurement            DMeas Output Voltage                  DMeas Output Current                  DMeas Output Power                   Register Functions                   DRecall Register                      DSave Register                        DStore Register Data                  DRead Register Data                   DStore Register Data Array           5Utility Functions                    DSet System Register                  DGet Register                         DCheck State                          DWrite To Instrument                  DRead Instrument Data                 DReset                                DSelf-Test                            DDiagnostics                          DError-Query                          DError Message                        DRevision Query                       DSet Display State                    DGet Display State                    DGet Instrument Model                 DSet I/O Delay Time                   DGet I/O Delay Time                   DAddress                              DLock Instrument                      DClose                           